package hxd.cn.sweepapp.utils;

import android.content.Context;
import android.widget.Toast;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

/**
 * Created by huxiongda on 2018/6/7.
 */

public class Tools {

    /*字节转换成String*/
    public static String Bytes2HexString(byte[] b) {
        String ret = "";
        for (int i = 0; i < b.length; i++) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            ret += " 0x" + hex.toUpperCase();
        }
        return ret;
    }

    /**
     * 判断是否为空
     */
    public static boolean isNull(String str) {
        return str == null || str.equals("") || str.equals("null") || str.equals("NULL");
    }

    /**
     * 弹出吐司
     */
    public static void showToast(Context context, String content) {
        Toast.makeText(context, content, Toast.LENGTH_SHORT).show();
    }

    /**
     * 弹出吐司
     */
    public static void showToast(Context context, int content) {
        Toast.makeText(context, content, Toast.LENGTH_SHORT).show();
    }

    public static String formatDate(long date) {
        SimpleDateFormat format = new SimpleDateFormat("MM-dd HH:mm");
        return format.format(new Date(date));
    }


    private static byte[] current1;
    private static byte[] current2;
    private static int current1len;
    private static int current2len;


    /**
     * @param data1
     * @param data2
     * @return data1 与 data2拼接的结果
     */
    public static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;

    }


    /**
     * get xor(parity bit)
     */
    public  static String getXor(String requestComm) {
        ArrayList<String> buff = new ArrayList<>();
        for (int i = 0; i < requestComm.length(); i = i + 2) {
            buff.add(requestComm.substring(i, i + 2));
        }
        int r = 0;
        for (String b : buff) {
            //把16进制的转换为10进制的数进行异或操作
            r = r ^ Integer.parseInt(String.valueOf(b), 16);
        }
        //得到异或的数之后在转换成16进制的
        String hex = Integer.toHexString(r & 0xFF);
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    public static String StringToA(String content){
        String result = "";
        int max = content.length();
        for (int i=0; i<max; i++){
            char c = content.charAt(i);
            int b = (int)c;
            result = result + b;
        }
        return result;
    }

    public static String setScannerGun(){
        SimpleDateFormat df=new SimpleDateFormat();
        df.applyPattern("yyyyMMddhhmmss");
        return df.format(new Date());
    }

}
